///////////////////////////////the standard templates scripts of 3d gamestudio
#include <acknex.h>
#include <default.c>
#include <mtlFX.c>
///////////////////////////////
#define PRAGMA_PATH "3dmodels" ///<<< we direct the engine to our made workfolders
#define PRAGMA_PATH "graphics"
#define PRAGMA_PATH "scripts"
#define PRAGMA_PATH "sounds"

action ship_movement();///<< we have to place it here otherwise the engine would not know this action exists
function restart_game(); ///<< we have to place it here otherwise the engine would not know this function exists

var soundtrack_handle;////<< remember how to control audio ? so a variable is needed.

SOUND* ammo_snd = "ammo.wav";/// this defines a sound we will use for the pickup
SOUND* explo_snd = "explosion.wav";/// this defines a sound we will use for the explosion

ENTITY* viper;///<<< we make the player model unique and recogniseble




ENTITY* sky = ///<<< we define the sky entity 
{
	type = "spacecube1+6.bmp"; ///<<< the picture we will use for the sky
	flags2 = SKY | CUBE | SHOW;///<<< the sky picture will show as a cube folding around your level without the need of putting it in a hollow cube.
}

var powerbox_count = 14; /// <<the name of our variable where we store the powerbox number and we set it on 14 at start. We need to catch 14 powerboxes

FONT*		fnt_pan = "Impact#40"; /// The true type font we want to use size
PANEL* pan_powerbox_count 	= {digits=10,10,"Power Boxes: %00.0f",fnt_pan,1,powerbox_count; //the panel where the number is shown on
	layer = 20; //the layer of the panel
	flags = SHOW;green=255; blue=0; red=255;// the color of the font that is used. This is yellow.
}

var wallhit_count = 3;///<< the name of our impact variable 3 times impact will be game over

FONT*		fnt_pan = "Impact#40"; /// The true type font we want to use size
PANEL* pan_wallhit_count 	= {digits=400,10,"Wall impact: %00.0f",fnt_pan,1,wallhit_count; //the panel where the number is shown on
	layer = 20; //the layer of the panel
	flags = SHOW;green=255; blue=0; red=255;// the color of the font that is used. This is yellow.
}







BMAP* complete_map = "missioncompleted.pcx"; ///<<< this map will show if the mission was a succes (on pickup red box end level).
PANEL* complete_pan =
{
	bmap = complete_map; // 
	pos_x = 360;///<<< the position on the x axis
	pos_y = 380;///<<< the position on the y axis
}

BMAP* failed_map = "missionfailed.pcx"; ///<<< this map will show if the mission was a failure. (on pickup red box end level).
PANEL* failed_pan =
{
	bmap = failed_map; 
	pos_x = 360;///<<< the position on the x axis
	pos_y = 280;///<<< the position on the y axis
}




function main()
{
	video_aspect = 1.333; ///<<< enforce 4:3 mode
	video_mode = 8;////<<< resolution
	video_screen = 2;///<<< play in window
	soundtrack_handle = media_loop("starcrossed.wav", NULL, 100);///<<< we use our variable to start and loop the music
	level_load("workshop08.WMB"); ////<<< loads the level we made
	camera.clip_far  = 6000;  ////<<< so the horizon will show when we get closer	
	shadow_stencil = 2; ///<<< will not work in free version of standard
	on_r = restart_game;///<< when pressed r it will start the restart function we made
	ent_create("ship.mdl", vector(-2006, 0, 11), ship_movement);///<<<create the ship at start postion and give it the movement action at game start
}

function restart_game()///<<< our restart function remember we named it also above the main so it will be recognized by the engine
{
	
	media_stop(soundtrack_handle);///<<< we use again our variable this time to stop the music as it will start in the main again
	powerbox_count = 14;///<<< we reset the powerbox variable to 14 again
	reset(failed_pan, SHOW | OVERLAY);////<<< we hide this panel
	reset(complete_pan, SHOW | OVERLAY);///<<< we hide this panel
	wallhit_count = 3; /// we reset the wallhit_count variable to 3 again 
	main(); ///<<< we go to main so the game fully restarts again
}



function sprite_played()///<<<the function we create for the explosion

{
	set (my, PASSABLE | BRIGHT | TRANSLUCENT);///<<< set the sprite passable bright en transparant
	my.scale_x = 1.5; // we scale it down to 0.15 ///<<<< we scale the original sprite
	my.scale_y = my.scale_x; // on both axis ////<<< we scale the original sprite
	my.ambient = 100; // and we give it an ambient of 100 ////<<< we give it some ambient
	my.roll = random(360); // we set a random roll angle ///<<< the sprite rolls random ways
	my.alpha = 100; // but we set it to be completely opaque for now ////<< we set the transparancy
	while (my.frame < 16) // go through all the animation frames ///<<<al sprite frames are 16 frames
	{
		my.frame += 2 * time_step; // animation speed ////<< plays the sprite from 1 to 16
		wait (1);
	}
	while (my.alpha > 0) // now fade the last frame quickly
	{
		my.alpha -= 2 * time_step; // 50 = fading speed ///<<< make the sprite fades out
		wait (1);
	}
	ent_remove (me); ///<<< remove the sprite after played full
}
//////////the ship movement/////////////////////////////




action ship_movement() ///<<< the name of the ships action.
{
	c_setminmax(me);   ////<<< set box for collision
	viper = me; ///<<< Remember the pointer we made it unique right ?
	set(my,SHADOW); ///<< turns on the shadow
	while (1) ///<<< after this we tell what the ship should do.
	{
		c_move (my, vector(45 * time_step, 0, 0), nullvector, GLIDE | IGNORE_PASSABLE); ///<<<the full move instruction the ship will keep moving forward it can move through passable objects
		if (key_cul) // the player has pressed the left cursor key then.....
		{
			my.y += 35*time_step;///<<< move to the left on the Y axis 
			if (my.roll > -20)///<< roll the ship model til it is bigger then -20
			{
				my.roll -= 5 * time_step;///<<< decide how fast the roll should go
			} 
		}
		else ///<<< if left cursor key is no longer pressed	
		{
			if (my.roll < 0) ////<<< roll the ship model til it is smaller then 0
			{
				my.roll += 5 * time_step; ///<<< decide how fast to roll back
			} 
		}
		if (key_cur) // the player has pressed the right cursor key then....
		{
			my.y -= 25*time_step; ///<<< move to the right on the Y axis 
			if (my.roll < 20)///<< roll the ship model til it is bigger smaller then 20
			{
				my.roll += 5 * time_step;///<<< decide how fast the roll should go
			}
		}
		else///<<< if left cursor key is no longer pressed
		{
			if (my.roll > 0)////<<< roll the ship model til it is smaller then 0
			{
				my.roll -= 5 * time_step;///<<< decide how fast the roll should go
			} 
		}
		if (my.x > 23700){ ///<<< when our ship is over the distance of 23700 on the x axis remember > = bigger then
			set(failed_pan,SHOW | OVERLAY);////<<<show failed panel
			
		}

		
		
		
		
		
		

		my.y = clamp(my.y, -400, 400);///<<< this keeps the ship between -400 and 400 on the y axis so it can't fly of the track here is clamp used to do this
		camera.x = my.x-200;///<<< Distance camera x axis from the model. Behind the model
		camera.y = my.y; ///<<< We do nothing with the y axis unless you want to
		camera.z = my.z + 110; ///<<< Distance height z axis from the model
		camera.tilt = -15; ///<<< make the camera look down on the model a bit
		wait (1);
	}
	
}




action rotator(){ ///<< name of the action we give to our ring sprites so the rotate
	set(my,PASSABLE | TRANSLUCENT | BRIGHT); ////<<< makes the sprite passeble so it won't get stuck sets it transparant and bright
	my.ambient = 200;///<<<give it some ambient
	while(1)///<<< after this we tell what the ring sprite what it should do.
	{
		set(my,PASSABLE); ////<<< makes the sprite passeble so it won't get stuck
		my.roll += 7* time_step;///<<< rotate continuesly at speed 7
		wait(1);
	}
}


action pickup_bonus() ///<<<the name of our action that we give to the powerboxes
{
	set(my,SHADOW | PASSABLE | BRIGHT);// set the model passable and give it shadow and make it bright
	wait(1); //wait one frame
	c_setminmax(my);// set proper collision BBOX
	while(!viper) //wait till our player is created the ship_movement action
	{
		wait(1);// wait one frame
	}
	while(vec_dist(my.x,viper.x) >50)// the distance between the viper and the pickup object
	{
		my.roll += 5* time_step;///<<< rotate continuesly at speed 5
		my.tilt += 5* time_step;///<<< tilting continuesly at speed 5
		wait(1);/// wait one frame
	}
	snd_play (ammo_snd, 100, 0);////<< play the sound file we defined when the model is picked up
	ent_remove(my);// we remove the pickup model
	powerbox_count -= 1; ///<<<subtract 1 point off our variable so eacht time we get one it's registered in our variable as found
}


action endlevel_bonus() ///<<<the name of our action get the red box to end the level and see if you made the score
{
	set(my,SHADOW | PASSABLE | BRIGHT);// set the model passable and give it shadow and make it bright
	wait(1); //wait one frame
	c_setminmax(my);// set proper collision BBOX
	my.ambient = 200;///<< give it some abient
	my.lightrange = 500;///<< make it light up and have a radius of light
	while(!viper) //wait till the player is created the hereiam action
	{
		wait(1);// wait one frame
	}
	while(vec_dist(my.x,viper.x) >50)// the distance between the viper and the pickup object
	{
		my.roll += 5* time_step;///<<< rotate continuesly at speed 5
		my.tilt += 5* time_step;///<<< tilting continuesly at speed 5
		wait(1);/// wait one frame
	}
	snd_play (ammo_snd, 100, 0);////"< play the sound file we defined 
	ent_remove(my);// we remove the pickup model
	if(powerbox_count ==0){///<<< if all boxes are found
		set(complete_pan,SHOW | OVERLAY);///<<< show the complete panel
		     ent_remove(viper);////<<then we remove our player model 
	}
	else///<<< if not then 
	if(powerbox_count > 0){ ///<<<if box count is bigger then zero
		set(failed_pan,SHOW | OVERLAY);///<<< show failed panel
		     ent_remove(viper); ////<<< we also remove the player model 
	}	
}

function entity_event_impact();////<<<place it here otherwise the engine won't recognise the function

action test_impact()/////<<< name of the action we give the block wall parts
{        

	my.emask |= ENABLE_IMPACT;///<<< make it sensible for impact
	my.event = entity_event_impact; /// <<< if there is impact goto the entity event_impact function
}

function entity_event_impact()///// <<<< Name of the function
{
	if (event_type == EVENT_IMPACT)/////<<< if there is impact
	{
		wallhit_count -=1; ///<< substract one point from the wallhit_count variable
		snd_play (explo_snd, 100, 0);////"< play the sound file we defined when the model is hit
		ent_create("explo2+16.tga", vector(my.x,my.y,my.z), sprite_played);////<<< creates the explosion sprite at block wall place and give it the sprite play function
		ent_remove(me);///<<< remove the exploded wall block
		if (wallhit_count <=0){wait(1);  ///<<< when our ship is over the distance of 23700 on the x axis remember > = bigger then
			set(failed_pan,SHOW | OVERLAY);////<<<show failed panel  cause it did not pick up  the red box right ? 
     ent_remove(viper);/////<<<<remove the player
}
}
}

